<?php
class ControllerExtensionModuleMenuicon extends Controller {
    public function index() {
        $this->load->language('extension/module/menuicon');
        $this->load->model('tool/image');

        $data['blocks'] = array();
        $blocks = $this->config->get('module_menuicon_blocks');
        if ($blocks && is_array($blocks)) {
            foreach ($blocks as $block) {
                $icon = '';
                if (!empty($block['icon_type']) && $block['icon_type'] == 'png' && !empty($block['icon'])) {
                    $icon = $this->model_tool_image->resize($block['icon'], 60, 60);
                }
                $data['blocks'][] = array(
                    'icon_type' => $block['icon_type'],
                    'icon'      => $icon,
                    'fa_class'  => $block['fa_class'],
                    'text'      => $block['text'],
                    'link'      => $block['link'],
                    'bgcolor'   => !empty($block['bgcolor']) ? $block['bgcolor'] : '#00b4e6',
                );
            }
        }
        return $this->load->view('extension/module/menuicon/menuicon', $data);
    }
}
