<?php
class ControllerExtensionModuleMenuicon extends Controller {
    private $error = array();

    public function index() {
        $this->load->language('extension/module/menuicon');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('module_menuicon', $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true));
        }

        $data['heading_title'] = $this->language->get('heading_title');
        $data['text_edit'] = $this->language->get('text_edit');
        $data['entry_status'] = $this->language->get('entry_status');
        $data['button_save'] = $this->language->get('button_save');
        $data['button_cancel'] = $this->language->get('button_cancel');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_extension'),
            'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/module/menuicon', 'user_token=' . $this->session->data['user_token'], true)
        );

        if (isset($this->request->post['module_menuicon_status'])) {
            $data['module_menuicon_status'] = $this->request->post['module_menuicon_status'];
        } else {
            $data['module_menuicon_status'] = $this->config->get('module_menuicon_status');
        }

        if (isset($this->request->post['module_menuicon_blocks'])) {
            $data['module_menuicon_blocks'] = $this->request->post['module_menuicon_blocks'];
        } else {
            $data['module_menuicon_blocks'] = $this->config->get('module_menuicon_blocks');
        }

        $data['action'] = $this->url->link('extension/module/menuicon', 'user_token=' . $this->session->data['user_token'], true);
        $data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);

        $this->load->model('tool/image');
        $data['placeholder'] = $this->model_tool_image->resize('no_image.png', 60, 60);

        if (!empty($data['module_menuicon_blocks'])) {
            foreach ($data['module_menuicon_blocks'] as &$block) {
                if (!empty($block['icon_type']) && $block['icon_type'] == 'png' && !empty($block['icon'])) {
                    $block['thumb'] = $this->model_tool_image->resize($block['icon'], 60, 60);
                } else {
                    $block['thumb'] = $data['placeholder'];
                }
            }
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/module/menuicon/menuicon_form', $data));
    }

    protected function validate() {
        if (!$this->user->hasPermission('modify', 'extension/module/menuicon')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        return !$this->error;
    }
}
